/****** Object:  View [dbo].[V_EST_NFE_INUTILIZACAO]    Script Date: 02/12/2014 12:04:37 ******/
IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_EST_NFE_INUTILIZACAO]'))
DROP VIEW [dbo].[V_EST_NFE_INUTILIZACAO]
GO
GO

--SELECT CD_FILIAL,NR_NF, SERIE,DT_CAD,TIPO_INUTILIZACAO,TRANSACAO,NM_USU,NR_PROTOCOLO,STS_PROCESSAMENTO FROM V_EST_NFE_INUTILIZACAO

CREATE VIEW V_EST_NFE_INUTILIZACAO AS 
SELECT
	EST_NF_NFE_INU.CD_INU,
	EST_NF_NFE_INU.CD_EMP,
	EST_NF_NFE_INU.CD_FILIAL,
	EST_NF_NFE_INU.NR_NF,
	EST_NF_SERIE.ESPC  + ' - ' + EST_NF_SERIE.SERIE AS SERIE,
	CONVERT(DATETIME,CONVERT(CHAR(10), EST_NF_NFE_INU.DT_CAD,120)) AS DT_CAD_PESQUISA,
	EST_NF_NFE_INU.DT_CAD,
	CASE WHEN ISNULL(EST_NF_NFE_INU_EF_NF_CTR_NR.CD_INU,0)=0 THEN
		'SOMENTE NUMERACAO'
	ELSE
		'NOTA EMITIDA E CANCELADA'
	END TIPO_INUTILIZACAO,
	CASE WHEN ISNULL(EST_NF_NFE_INU_EF_NF_CTR_NR.CD_INU,0)=0 THEN
		''
	ELSE
		CASE WHEN ISNULL(EST_NF_ENT_EF_NF_CTR_NF.CD_EMP,0)=0 THEN
			'SAIDA'
		ELSE
			'ENTRADA'
		END
	END AS TRANSACAO,
	ISNULL(EST_NF_NFE_INU_VALIDADA.NR_PROTOCOLO,0) AS NR_PROTOCOLO,
	ISNULL(NM_USU,'NAO IDENTIFICADO') AS NM_USU,
	
    COALESCE(  
     (
      SELECT 
        DS_MOTIVO
        
      FROM  
       nfe..EST_NF_NFE_INUTILIZACAO O
      WHERE
        O.INICIAL = EST_NF_NFE_INU.NR_NF
        AND  O.CNPJ = REPLACE( REPLACE( REPLACE(F.CGC,'-',''),'/',''),'.','')
        AND  O.MODELO   = EST_NF_NFE_INU.CD_MODELO
        AND  O.SERIE   =  EST_NF_SERIE.SERIE
    ),'NAO ENVIADO') AS STS_PROCESSAMENTO  
 
    
    
FROM
	EST_NF_NFE_INU LEFT OUTER JOIN EST_NF_NFE_INU_EF_NF_CTR_NR ON
	EST_NF_NFE_INU.CD_INU = EST_NF_NFE_INU_EF_NF_CTR_NR.CD_INU
	LEFT OUTER JOIN EST_NF_NFE_INU_VALIDADA ON
	EST_NF_NFE_INU.CD_INU = EST_NF_NFE_INU_VALIDADA.CD_INU
	LEFT OUTER JOIN EST_NF_NFE_INU_PEND ON
	EST_NF_NFE_INU.CD_INU = EST_NF_NFE_INU_PEND.CD_INU
	LEFT OUTER JOIN GLB_USU ON
	EST_NF_NFE_INU.CD_USU = GLB_USU.CD_USU
	INNER JOIN EST_NF_SERIE ON
	EST_NF_NFE_INU.CD_NF_SERIE=EST_NF_SERIE.CD_NF_SERIE
	LEFT OUTER JOIN EST_NF_ENT_EF_NF_CTR_NF ON
	EST_NF_NFE_INU_EF_NF_CTR_NR.CD_EMP = EST_NF_ENT_EF_NF_CTR_NF.CD_EMP AND
	EST_NF_NFE_INU_EF_NF_CTR_NR.CD_FILIAL = EST_NF_ENT_EF_NF_CTR_NF.CD_FILIAL AND
	EST_NF_NFE_INU_EF_NF_CTR_NR.NR_NF = EST_NF_ENT_EF_NF_CTR_NF.NR_NF AND
	EST_NF_NFE_INU_EF_NF_CTR_NR.CD_NF_SERIE = EST_NF_ENT_EF_NF_CTR_NF.CD_NF_SERIE
    INNER JOIN PRC_FILIAL  F ON
      F.CD_FILIAL   =EST_NF_NFE_INU.CD_FILIAL